/* eval - Evaluate a command line */
/* Author: Cyrille Pontvieux <jrd@enialis.net>
 * Licence: GPL v3+ */

#include <grub/dl.h>
#include <grub/misc.h>
#include <grub/parser.h>
#include <grub/script_sh.h>
#include <grub/command.h>

GRUB_MOD_LICENSE ("GPLv3+");

static grub_err_t
grub_cmd_eval (grub_command_t cmd __attribute__ ((unused)), int argc, char **args)
{
  char* cmdline;
  if (argc < 1)
  {
    return grub_error (GRUB_ERR_BAD_ARGUMENT, "missing arguments");
  }
  cmdline = args[0];
  if (!grub_normal_parse_line (cmdline, 0))
  {
    return grub_errno;
  }
  else
  {
    return 0;
  }
}

static grub_command_t cmd;

GRUB_MOD_INIT (eval)
{
  cmd = grub_register_command ("eval", grub_cmd_eval,
            N_("command"),
            N_("Evaluate the command as if you typed it."));
}

GRUB_MOD_FINI (eval)
{
  grub_unregister_command (cmd);
}
