/*
 * Copyright (C) 2009-2011 Christopho, Solarus - http://www.solarus-engine.org
 * 
 * Solarus is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Solarus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SOLARUS_CRYSTAL_H
#define SOLARUS_CRYSTAL_H

#include "Common.h"
#include "entities/Detector.h"
#include <list>

/**
 * @brief A switch that can be activated to change the state of the
 * crystal blocks.
 */
class Crystal: public Detector {

  private:

    bool state;                                    /**< false if the orange blocks are lowered,
                                                    * true if the blue blocks are lowered */
    uint32_t next_possible_hit_date;               /**< date when the crystal can be hit again */
    std::list<MapEntity*> entities_activating;     /**< list of entities that recently activated this crystal */
    Sprite* star_sprite;                           /**< sprite of the star twinkling on the crystal */
    Rectangle star_xy;                             /**< position of the star */

    void twinkle();

  public:

    Crystal(const std::string& name, Layer layer, int x, int y);
    ~Crystal();
    static CreationFunction parse;

    EntityType get_type();

    void notify_map_started();
    bool is_obstacle_for(MapEntity& other);
    void notify_collision(MapEntity& entity_overlapping, CollisionMode collision_mode);
    void notify_collision(MapEntity& other_entity, Sprite& other_sprite, Sprite& this_sprite);
    void action_key_pressed();
    void activate(MapEntity& entity_activating);

    void update();
    void display_on_map();
    void set_suspended(bool suspended);
};

#endif

