/*
 * Decompiled with CFR 0.152.
 */
package dom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMAddLines
extends DOMParser {
    private PrintWriter out;
    private static boolean NotIncludeIgnorableWhiteSpaces = false;
    private XMLLocator locator;

    public DOMAddLines(String string) {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parse(string);
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
        }
        catch (IOException iOException) {
            System.err.println("except" + iOException);
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        String string = (String)node.getUserData("startLine");
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.out.println(string + ":" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                Object object;
                this.out.print(string + ":" + '<');
                this.out.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                int n = 0;
                while (n < attrArray.length) {
                    object = attrArray[n];
                    this.out.print(' ');
                    this.out.print(object.getNodeName());
                    this.out.print("=\"");
                    this.out.print(object.getNodeValue());
                    this.out.print('\"');
                    ++n;
                }
                this.out.print('>');
                object = node.getChildNodes();
                if (object == null) break;
                int n2 = object.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    this.print(object.item(n3));
                    ++n3;
                }
                break;
            }
            case 5: {
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string2);
                }
                this.out.print("?>");
            }
        }
        if (s == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        super.startElement(qName, xMLAttributes, augmentations);
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(this.locator.getLineNumber()), null);
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
        this.locator = xMLLocator;
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(xMLLocator.getLineNumber()), null);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!NotIncludeIgnorableWhiteSpaces) {
            super.ignorableWhitespace(xMLString, augmentations);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            DOMAddLines.printUsage();
            System.exit(1);
        }
        var1_1 = 0;
        while (var1_1 < var0.length) {
            var2_2 = var0[var1_1];
            if (!var2_2.startsWith("-")) ** GOTO lbl-1000
            if (var2_2.equals("-h")) {
                DOMAddLines.printUsage();
                System.exit(1);
            }
            if (var2_2.equals("-i")) {
                DOMAddLines.NotIncludeIgnorableWhiteSpaces = true;
            } else lbl-1000:
            // 2 sources

            {
                var3_3 = new DOMAddLines(var2_2);
                var4_4 = var3_3.getDocument();
                var3_3.print(var4_4);
            }
            ++var1_1;
        }
    }

    private static void printUsage() {
        System.err.println("usage: jre dom.DOMAddLines (options) uri ...");
        System.err.println();
        System.err.println("  -h       Display help screen.");
        System.err.println("  -i       Don't print ignorable white spaces.");
    }
}

