/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.model.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

public abstract class ContainerNode<T>
extends HeapViewerNode {
    protected final int maxNodes;
    protected final List<T> items;
    protected final String name;
    protected int count = DataType.COUNT.getUnsupportedValue();
    protected long ownSize = DataType.OWN_SIZE.getUnsupportedValue();
    protected long retainedSize = DataType.RETAINED_SIZE.getUnsupportedValue();

    public ContainerNode(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public ContainerNode(String name, int maxNodes) {
        this.name = name;
        this.maxNodes = maxNodes;
        this.items = new ArrayList<T>();
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public long getOwnSize() {
        return this.ownSize;
    }

    public long getRetainedSize(Heap heap) {
        if (this.retainedSize == DataType.RETAINED_SIZE.getNotAvailableValue() && DataType.RETAINED_SIZE.valuesAvailable(heap)) {
            this.retainedSize = 0L;
            for (T item : this.items) {
                this.retainedSize += this.getRetainedSize(item, heap);
            }
        }
        return this.retainedSize;
    }

    protected abstract HeapViewerNode createNode(T var1);

    protected int getCount(T item, Heap heap) {
        return DataType.COUNT.getUnsupportedValue();
    }

    protected long getOwnSize(T item, Heap heap) {
        return DataType.OWN_SIZE.getUnsupportedValue();
    }

    protected long getRetainedSize(T item, Heap heap) {
        return DataType.RETAINED_SIZE.getUnsupportedValue();
    }

    protected boolean sorts(DataType dataType) {
        return true;
    }

    protected String getMoreNodesString(String moreNodesCount) {
        return Bundle.ContainerNode_MoreNodes(moreNodesCount);
    }

    protected String getSamplesContainerString(String objectsCount) {
        return Bundle.ContainerNode_SamplesContainer(objectsCount);
    }

    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.ContainerNode_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    public String toString() {
        return this.name;
    }

    public void add(T item, Heap heap) {
        long _ownSize;
        this.items.add(item);
        int _count = this.getCount(item, heap);
        if (_count >= 0) {
            if (this.count < 0) {
                this.count = 0;
            }
            this.count += _count;
        }
        if ((_ownSize = this.getOwnSize(item, heap)) >= 0L) {
            if (this.ownSize < 0L) {
                this.ownSize = 0L;
            }
            this.ownSize += _ownSize;
        }
        if (this.retainedSize != DataType.RETAINED_SIZE.getNotAvailableValue()) {
            long _retainedSize = this.getRetainedSize(item, heap);
            if (_retainedSize >= 0L) {
                if (this.retainedSize < 0L) {
                    this.retainedSize = 0L;
                }
                this.retainedSize += _retainedSize;
            } else if (_retainedSize == DataType.RETAINED_SIZE.getNotAvailableValue()) {
                this.retainedSize = _retainedSize;
            }
        }
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    protected HeapViewerNode[] computeChildren(RootNode root) {
        int itemsCount = this.items.size();
        if (itemsCount <= this.maxNodes) {
            HeapViewerNode[] nodes = new HeapViewerNode[itemsCount];
            for (int i = 0; i < itemsCount; ++i) {
                nodes[i] = this.createNode(this.items.get(i));
            }
            return nodes;
        }
        return super.computeChildren(root);
    }

    @Override
    protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        NodesComputer computer = new NodesComputer<T>(this.items.size(), this.maxNodes){

            @Override
            protected boolean sorts(DataType dataType) {
                return ContainerNode.this.sorts(dataType);
            }

            @Override
            protected HeapViewerNode createNode(T object) {
                return ContainerNode.this.createNode(object);
            }

            @Override
            protected ProgressIterator<T> objectsIterator(int index, Progress progress) {
                ListIterator iterator = ContainerNode.this.items.listIterator(index);
                return new ProgressIterator(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return ContainerNode.this.getMoreNodesString(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return ContainerNode.this.getSamplesContainerString(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return ContainerNode.this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerNode)) {
            return false;
        }
        return this.name.equals(((ContainerNode)((Object)o)).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isLeaf() {
        return this.items.isEmpty();
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName();
        }
        if (type == DataType.COUNT) {
            return this.getCount();
        }
        if (type == DataType.OWN_SIZE) {
            return this.getOwnSize();
        }
        if (type == DataType.RETAINED_SIZE) {
            return this.getRetainedSize(heap);
        }
        return super.getValue(type, heap);
    }

    public static class Nodes<T extends HeapViewerNode>
    extends ContainerNode<T> {
        public Nodes(String name) {
            this(name, Integer.MAX_VALUE);
        }

        public Nodes(String name, int maxNodes) {
            super(name, maxNodes);
        }

        @Override
        protected int getCount(T item, Heap heap) {
            return HeapViewerNode.getValue(item, DataType.COUNT, heap);
        }

        @Override
        protected long getOwnSize(T item, Heap heap) {
            return HeapViewerNode.getValue(item, DataType.OWN_SIZE, heap);
        }

        @Override
        protected long getRetainedSize(T item, Heap heap) {
            return HeapViewerNode.getValue(item, DataType.RETAINED_SIZE, heap);
        }

        @Override
        protected HeapViewerNode[] computeChildren(RootNode root) {
            if (this.items.size() <= this.maxNodes) {
                return this.items.toArray(HeapViewerNode.NO_NODES);
            }
            return super.computeChildren(root);
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            NodesComputer computer = new NodesComputer<T>(this.items.size(), this.maxNodes){

                @Override
                protected boolean sorts(DataType dataType) {
                    return this.sorts(dataType);
                }

                @Override
                protected HeapViewerNode createNode(T object) {
                    return object;
                }

                @Override
                protected ProgressIterator<T> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = items.listIterator(index);
                    return new ProgressIterator(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return this.getMoreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return this.getSamplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        @Override
        protected HeapViewerNode createNode(HeapViewerNode item) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

