/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.Utils;

public class DataSourceConnectionFactory
implements ConnectionFactory {
    private final DataSource dataSource;
    private final String userName;
    private final char[] userPassword;

    public DataSourceConnectionFactory(DataSource dataSource) {
        this(dataSource, null, (char[])null);
    }

    public DataSourceConnectionFactory(DataSource dataSource, String string, char[] cArray) {
        this.dataSource = dataSource;
        this.userName = string;
        this.userPassword = Utils.clone(cArray);
    }

    public DataSourceConnectionFactory(DataSource dataSource, String string, String string2) {
        this.dataSource = dataSource;
        this.userName = string;
        this.userPassword = Utils.toCharArray(string2);
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (null == this.userName && null == this.userPassword) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(this.userName, Utils.toString(this.userPassword));
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getUserPassword() {
        return Utils.clone(this.userPassword);
    }
}

