\name{ApproximateSignedDistanceMapImageFilter}
\alias{ApproximateSignedDistanceMapImageFilter}
\title{ApproximateSignedDistanceMapImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Create a map of the approximate signed distance from the boundaries of
a binary image.
ApproximateSignedDistanceMapImageFilter}
\details{
The ApproximateSignedDistanceMapImageFilter takes as input a binary image and produces a signed distance map.
Each pixel value in the output contains the approximate distance from
that pixel to the nearest "object" in the binary image. This filter
differs from the DanielssonDistanceMapImageFilter in that it calculates the distance to the "object edge" for pixels
within the object.
Negative values in the output indicate that the pixel at that position
is within an object in the input image. The absolute value of a
negative pixel represents the approximate distance to the nearest
object boundary pixel.
WARNING: This filter requires that the output type be floating-point.
Otherwise internal calculations will not be performed to the
appropriate precision, resulting in completely incorrect (read: zero-
valued) output.
The distances computed by this filter are Chamfer distances, which are
only an approximation to Euclidean distances, and are not as exact
approximations as those calculated by the DanielssonDistanceMapImageFilter . On the other hand, this filter is faster.
This filter requires that an "inside value" and "outside value" be
set as parameters. The "inside value" is the intensity value of the
binary image which corresponds to objects, and the "outside value"
is the intensity of the background. (A typical binary image often
represents objects as black (0) and background as white (usually 255),
or vice-versa.) Note that this filter is slightly faster if the inside
value is less than the outside value. Otherwise an extra iteration
through the image is required.
This filter uses the FastChamferDistanceImageFilter and the IsoContourDistanceImageFilter internally to perform the distance calculations.
See:
DanielssonDistanceMapImageFilter
SignedDanielssonDistanceMapImageFilter
SignedMaurerDistanceMapImageFilter
FastChamferDistanceImageFilter
IsoContourDistanceImageFilter
Zach Pincus
See:
ApproximateSignedDistanceMap for the procedural interface
itk::ApproximateSignedDistanceMapImageFilter for the Doxygen on the original ITK class.
ApproximateSignedDistanceMapImageFilter}
%C++ includes: sitkApproximateSignedDistanceMapImageFilter.h
\section{Methods}{
\describe{
\item{ ApproximateSignedDistanceMapImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetInsideValue() const:}{
Set/Get intensity value representing the interior of objects in the
mask.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutsideValue() const:}{
Set/Get intensity value representing non-objects in the mask.
}
\item{Self SetInsideValue(double InsideValue):}{
Set/Get intensity value representing the interior of objects in the
mask.
}
\item{Self SetOutsideValue(double OutsideValue):}{
Set/Get intensity value representing non-objects in the mask.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ApproximateSignedDistanceMapImageFilter():}{
Destructor
}
}
}
