/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenameObjectRequest
extends S3Request
implements ToCopyableBuilder<Builder, RenameObjectRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(RenameObjectRequest.getter(RenameObjectRequest::bucket)).setter(RenameObjectRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket").unmarshallLocationName("Bucket").build(), RequiredTrait.create()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(RenameObjectRequest.getter(RenameObjectRequest::key)).setter(RenameObjectRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Key").unmarshallLocationName("Key").build(), RequiredTrait.create()}).build();
    private static final SdkField<String> RENAME_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenameSource").getter(RenameObjectRequest.getter(RenameObjectRequest::renameSource)).setter(RenameObjectRequest.setter(Builder::renameSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-rename-source").unmarshallLocationName("x-amz-rename-source").build(), RequiredTrait.create()}).build();
    private static final SdkField<String> DESTINATION_IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIfMatch").getter(RenameObjectRequest.getter(RenameObjectRequest::destinationIfMatch)).setter(RenameObjectRequest.setter(Builder::destinationIfMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<String> DESTINATION_IF_NONE_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIfNoneMatch").getter(RenameObjectRequest.getter(RenameObjectRequest::destinationIfNoneMatch)).setter(RenameObjectRequest.setter(Builder::destinationIfNoneMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-None-Match").unmarshallLocationName("If-None-Match").build()}).build();
    private static final SdkField<Instant> DESTINATION_IF_MODIFIED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DestinationIfModifiedSince").getter(RenameObjectRequest.getter(RenameObjectRequest::destinationIfModifiedSince)).setter(RenameObjectRequest.setter(Builder::destinationIfModifiedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Modified-Since").unmarshallLocationName("If-Modified-Since").build()}).build();
    private static final SdkField<Instant> DESTINATION_IF_UNMODIFIED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DestinationIfUnmodifiedSince").getter(RenameObjectRequest.getter(RenameObjectRequest::destinationIfUnmodifiedSince)).setter(RenameObjectRequest.setter(Builder::destinationIfUnmodifiedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Unmodified-Since").unmarshallLocationName("If-Unmodified-Since").build()}).build();
    private static final SdkField<String> SOURCE_IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIfMatch").getter(RenameObjectRequest.getter(RenameObjectRequest::sourceIfMatch)).setter(RenameObjectRequest.setter(Builder::sourceIfMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-rename-source-if-match").unmarshallLocationName("x-amz-rename-source-if-match").build()}).build();
    private static final SdkField<String> SOURCE_IF_NONE_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIfNoneMatch").getter(RenameObjectRequest.getter(RenameObjectRequest::sourceIfNoneMatch)).setter(RenameObjectRequest.setter(Builder::sourceIfNoneMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-rename-source-if-none-match").unmarshallLocationName("x-amz-rename-source-if-none-match").build()}).build();
    private static final SdkField<Instant> SOURCE_IF_MODIFIED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SourceIfModifiedSince").getter(RenameObjectRequest.getter(RenameObjectRequest::sourceIfModifiedSince)).setter(RenameObjectRequest.setter(Builder::sourceIfModifiedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-rename-source-if-modified-since").unmarshallLocationName("x-amz-rename-source-if-modified-since").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.RFC_822)}).build();
    private static final SdkField<Instant> SOURCE_IF_UNMODIFIED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SourceIfUnmodifiedSince").getter(RenameObjectRequest.getter(RenameObjectRequest::sourceIfUnmodifiedSince)).setter(RenameObjectRequest.setter(Builder::sourceIfUnmodifiedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-rename-source-if-unmodified-since").unmarshallLocationName("x-amz-rename-source-if-unmodified-since").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.RFC_822)}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RenameObjectRequest.getter(RenameObjectRequest::clientToken)).setter(RenameObjectRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-client-token").unmarshallLocationName("x-amz-client-token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD, RENAME_SOURCE_FIELD, DESTINATION_IF_MATCH_FIELD, DESTINATION_IF_NONE_MATCH_FIELD, DESTINATION_IF_MODIFIED_SINCE_FIELD, DESTINATION_IF_UNMODIFIED_SINCE_FIELD, SOURCE_IF_MATCH_FIELD, SOURCE_IF_NONE_MATCH_FIELD, SOURCE_IF_MODIFIED_SINCE_FIELD, SOURCE_IF_UNMODIFIED_SINCE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RenameObjectRequest.memberNameToFieldInitializer();
    private final String bucket;
    private final String key;
    private final String renameSource;
    private final String destinationIfMatch;
    private final String destinationIfNoneMatch;
    private final Instant destinationIfModifiedSince;
    private final Instant destinationIfUnmodifiedSince;
    private final String sourceIfMatch;
    private final String sourceIfNoneMatch;
    private final Instant sourceIfModifiedSince;
    private final Instant sourceIfUnmodifiedSince;
    private final String clientToken;

    private RenameObjectRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.renameSource = builder.renameSource;
        this.destinationIfMatch = builder.destinationIfMatch;
        this.destinationIfNoneMatch = builder.destinationIfNoneMatch;
        this.destinationIfModifiedSince = builder.destinationIfModifiedSince;
        this.destinationIfUnmodifiedSince = builder.destinationIfUnmodifiedSince;
        this.sourceIfMatch = builder.sourceIfMatch;
        this.sourceIfNoneMatch = builder.sourceIfNoneMatch;
        this.sourceIfModifiedSince = builder.sourceIfModifiedSince;
        this.sourceIfUnmodifiedSince = builder.sourceIfUnmodifiedSince;
        this.clientToken = builder.clientToken;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String key() {
        return this.key;
    }

    public final String renameSource() {
        return this.renameSource;
    }

    public final String destinationIfMatch() {
        return this.destinationIfMatch;
    }

    public final String destinationIfNoneMatch() {
        return this.destinationIfNoneMatch;
    }

    public final Instant destinationIfModifiedSince() {
        return this.destinationIfModifiedSince;
    }

    public final Instant destinationIfUnmodifiedSince() {
        return this.destinationIfUnmodifiedSince;
    }

    public final String sourceIfMatch() {
        return this.sourceIfMatch;
    }

    public final String sourceIfNoneMatch() {
        return this.sourceIfNoneMatch;
    }

    public final Instant sourceIfModifiedSince() {
        return this.sourceIfModifiedSince;
    }

    public final Instant sourceIfUnmodifiedSince() {
        return this.sourceIfUnmodifiedSince;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIfMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIfNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIfModifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIfUnmodifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIfMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIfNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIfModifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIfUnmodifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameObjectRequest)) {
            return false;
        }
        RenameObjectRequest other = (RenameObjectRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.renameSource(), other.renameSource()) && Objects.equals(this.destinationIfMatch(), other.destinationIfMatch()) && Objects.equals(this.destinationIfNoneMatch(), other.destinationIfNoneMatch()) && Objects.equals(this.destinationIfModifiedSince(), other.destinationIfModifiedSince()) && Objects.equals(this.destinationIfUnmodifiedSince(), other.destinationIfUnmodifiedSince()) && Objects.equals(this.sourceIfMatch(), other.sourceIfMatch()) && Objects.equals(this.sourceIfNoneMatch(), other.sourceIfNoneMatch()) && Objects.equals(this.sourceIfModifiedSince(), other.sourceIfModifiedSince()) && Objects.equals(this.sourceIfUnmodifiedSince(), other.sourceIfUnmodifiedSince()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"RenameObjectRequest").add("Bucket", (Object)this.bucket()).add("Key", (Object)this.key()).add("RenameSource", (Object)this.renameSource()).add("DestinationIfMatch", (Object)this.destinationIfMatch()).add("DestinationIfNoneMatch", (Object)this.destinationIfNoneMatch()).add("DestinationIfModifiedSince", (Object)this.destinationIfModifiedSince()).add("DestinationIfUnmodifiedSince", (Object)this.destinationIfUnmodifiedSince()).add("SourceIfMatch", (Object)this.sourceIfMatch()).add("SourceIfNoneMatch", (Object)this.sourceIfNoneMatch()).add("SourceIfModifiedSince", (Object)this.sourceIfModifiedSince()).add("SourceIfUnmodifiedSince", (Object)this.sourceIfUnmodifiedSince()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "RenameSource": {
                return Optional.ofNullable(clazz.cast(this.renameSource()));
            }
            case "DestinationIfMatch": {
                return Optional.ofNullable(clazz.cast(this.destinationIfMatch()));
            }
            case "DestinationIfNoneMatch": {
                return Optional.ofNullable(clazz.cast(this.destinationIfNoneMatch()));
            }
            case "DestinationIfModifiedSince": {
                return Optional.ofNullable(clazz.cast(this.destinationIfModifiedSince()));
            }
            case "DestinationIfUnmodifiedSince": {
                return Optional.ofNullable(clazz.cast(this.destinationIfUnmodifiedSince()));
            }
            case "SourceIfMatch": {
                return Optional.ofNullable(clazz.cast(this.sourceIfMatch()));
            }
            case "SourceIfNoneMatch": {
                return Optional.ofNullable(clazz.cast(this.sourceIfNoneMatch()));
            }
            case "SourceIfModifiedSince": {
                return Optional.ofNullable(clazz.cast(this.sourceIfModifiedSince()));
            }
            case "SourceIfUnmodifiedSince": {
                return Optional.ofNullable(clazz.cast(this.sourceIfUnmodifiedSince()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("Key", KEY_FIELD);
        map.put("x-amz-rename-source", RENAME_SOURCE_FIELD);
        map.put("If-Match", DESTINATION_IF_MATCH_FIELD);
        map.put("If-None-Match", DESTINATION_IF_NONE_MATCH_FIELD);
        map.put("If-Modified-Since", DESTINATION_IF_MODIFIED_SINCE_FIELD);
        map.put("If-Unmodified-Since", DESTINATION_IF_UNMODIFIED_SINCE_FIELD);
        map.put("x-amz-rename-source-if-match", SOURCE_IF_MATCH_FIELD);
        map.put("x-amz-rename-source-if-none-match", SOURCE_IF_NONE_MATCH_FIELD);
        map.put("x-amz-rename-source-if-modified-since", SOURCE_IF_MODIFIED_SINCE_FIELD);
        map.put("x-amz-rename-source-if-unmodified-since", SOURCE_IF_UNMODIFIED_SINCE_FIELD);
        map.put("x-amz-client-token", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenameObjectRequest, T> g) {
        return obj -> g.apply((RenameObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private String renameSource;
        private String destinationIfMatch;
        private String destinationIfNoneMatch;
        private Instant destinationIfModifiedSince;
        private Instant destinationIfUnmodifiedSince;
        private String sourceIfMatch;
        private String sourceIfNoneMatch;
        private Instant sourceIfModifiedSince;
        private Instant sourceIfUnmodifiedSince;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameObjectRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.key(model.key);
            this.renameSource(model.renameSource);
            this.destinationIfMatch(model.destinationIfMatch);
            this.destinationIfNoneMatch(model.destinationIfNoneMatch);
            this.destinationIfModifiedSince(model.destinationIfModifiedSince);
            this.destinationIfUnmodifiedSince(model.destinationIfUnmodifiedSince);
            this.sourceIfMatch(model.sourceIfMatch);
            this.sourceIfNoneMatch(model.sourceIfNoneMatch);
            this.sourceIfModifiedSince(model.sourceIfModifiedSince);
            this.sourceIfUnmodifiedSince(model.sourceIfUnmodifiedSince);
            this.clientToken(model.clientToken);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getRenameSource() {
            return this.renameSource;
        }

        public final void setRenameSource(String renameSource) {
            this.renameSource = renameSource;
        }

        @Override
        public final Builder renameSource(String renameSource) {
            this.renameSource = renameSource;
            return this;
        }

        public final String getDestinationIfMatch() {
            return this.destinationIfMatch;
        }

        public final void setDestinationIfMatch(String destinationIfMatch) {
            this.destinationIfMatch = destinationIfMatch;
        }

        @Override
        public final Builder destinationIfMatch(String destinationIfMatch) {
            this.destinationIfMatch = destinationIfMatch;
            return this;
        }

        public final String getDestinationIfNoneMatch() {
            return this.destinationIfNoneMatch;
        }

        public final void setDestinationIfNoneMatch(String destinationIfNoneMatch) {
            this.destinationIfNoneMatch = destinationIfNoneMatch;
        }

        @Override
        public final Builder destinationIfNoneMatch(String destinationIfNoneMatch) {
            this.destinationIfNoneMatch = destinationIfNoneMatch;
            return this;
        }

        public final Instant getDestinationIfModifiedSince() {
            return this.destinationIfModifiedSince;
        }

        public final void setDestinationIfModifiedSince(Instant destinationIfModifiedSince) {
            this.destinationIfModifiedSince = destinationIfModifiedSince;
        }

        @Override
        public final Builder destinationIfModifiedSince(Instant destinationIfModifiedSince) {
            this.destinationIfModifiedSince = destinationIfModifiedSince;
            return this;
        }

        public final Instant getDestinationIfUnmodifiedSince() {
            return this.destinationIfUnmodifiedSince;
        }

        public final void setDestinationIfUnmodifiedSince(Instant destinationIfUnmodifiedSince) {
            this.destinationIfUnmodifiedSince = destinationIfUnmodifiedSince;
        }

        @Override
        public final Builder destinationIfUnmodifiedSince(Instant destinationIfUnmodifiedSince) {
            this.destinationIfUnmodifiedSince = destinationIfUnmodifiedSince;
            return this;
        }

        public final String getSourceIfMatch() {
            return this.sourceIfMatch;
        }

        public final void setSourceIfMatch(String sourceIfMatch) {
            this.sourceIfMatch = sourceIfMatch;
        }

        @Override
        public final Builder sourceIfMatch(String sourceIfMatch) {
            this.sourceIfMatch = sourceIfMatch;
            return this;
        }

        public final String getSourceIfNoneMatch() {
            return this.sourceIfNoneMatch;
        }

        public final void setSourceIfNoneMatch(String sourceIfNoneMatch) {
            this.sourceIfNoneMatch = sourceIfNoneMatch;
        }

        @Override
        public final Builder sourceIfNoneMatch(String sourceIfNoneMatch) {
            this.sourceIfNoneMatch = sourceIfNoneMatch;
            return this;
        }

        public final Instant getSourceIfModifiedSince() {
            return this.sourceIfModifiedSince;
        }

        public final void setSourceIfModifiedSince(Instant sourceIfModifiedSince) {
            this.sourceIfModifiedSince = sourceIfModifiedSince;
        }

        @Override
        public final Builder sourceIfModifiedSince(Instant sourceIfModifiedSince) {
            this.sourceIfModifiedSince = sourceIfModifiedSince;
            return this;
        }

        public final Instant getSourceIfUnmodifiedSince() {
            return this.sourceIfUnmodifiedSince;
        }

        public final void setSourceIfUnmodifiedSince(Instant sourceIfUnmodifiedSince) {
            this.sourceIfUnmodifiedSince = sourceIfUnmodifiedSince;
        }

        @Override
        public final Builder sourceIfUnmodifiedSince(Instant sourceIfUnmodifiedSince) {
            this.sourceIfUnmodifiedSince = sourceIfUnmodifiedSince;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenameObjectRequest build() {
            return new RenameObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RenameObjectRequest> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder renameSource(String var1);

        public Builder destinationIfMatch(String var1);

        public Builder destinationIfNoneMatch(String var1);

        public Builder destinationIfModifiedSince(Instant var1);

        public Builder destinationIfUnmodifiedSince(Instant var1);

        public Builder sourceIfMatch(String var1);

        public Builder sourceIfNoneMatch(String var1);

        public Builder sourceIfModifiedSince(Instant var1);

        public Builder sourceIfUnmodifiedSince(Instant var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

