/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.tasks.GroupBy;
import org.opensearch.client.opensearch.tasks.ListResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ListRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ListRequest> {
    @Nonnull
    private final List<String> actions;
    @Nullable
    private final Boolean detailed;
    @Nullable
    private final GroupBy groupBy;
    @Nonnull
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ListRequest, ListResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ListRequest, ListResponse>(request -> "GET", request -> "/_tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ListResponse._DESERIALIZER);

    private ListRequest(Builder builder) {
        super(builder);
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.detailed = builder.detailed;
        this.groupBy = builder.groupBy;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.timeout = builder.timeout;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static ListRequest of(Function<Builder, ObjectBuilder<ListRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> actions() {
        return this.actions;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nullable
    public final GroupBy groupBy() {
        return this.groupBy;
    }

    @Nonnull
    public final List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.actions)) {
            params.put("actions", String.join((CharSequence)",", this.actions));
        }
        if (this.detailed != null) {
            params.put("detailed", String.valueOf(this.detailed));
        }
        if (this.groupBy != null) {
            params.put("group_by", this.groupBy.jsonValue());
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            params.put("nodes", String.join((CharSequence)",", this.nodes));
        }
        if (this.parentTaskId != null) {
            params.put("parent_task_id", this.parentTaskId);
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.actions);
        result = 31 * result + Objects.hashCode(this.detailed);
        result = 31 * result + Objects.hashCode(this.groupBy);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.parentTaskId);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListRequest other = (ListRequest)o;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.detailed, other.detailed) && Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.parentTaskId, other.parentTaskId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ListRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private Boolean detailed;
        @Nullable
        private GroupBy groupBy;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(ListRequest o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.detailed = o.detailed;
            this.groupBy = o.groupBy;
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.timeout = o.timeout;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.actions = Builder._listCopy(o.actions);
            this.detailed = o.detailed;
            this.groupBy = o.groupBy;
            this.nodes = Builder._listCopy(o.nodes);
            this.parentTaskId = o.parentTaskId;
            this.timeout = o.timeout;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        @Nonnull
        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        @Nonnull
        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Nonnull
        public final Builder groupBy(@Nullable GroupBy value) {
            this.groupBy = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(List<String> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        @Nonnull
        public final Builder nodes(String value, String ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public ListRequest build() {
            this._checkSingleUse();
            return new ListRequest(this);
        }
    }
}

