/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.opensearch.common.Nullable;
import org.opensearch.common.time.DateUtils;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.AbstractSortedNumericDocValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.HalfFloatValuesComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.IntValuesComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.UnsignedLongValuesComparatorSource;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public abstract class IndexNumericFieldData
implements IndexFieldData<LeafNumericFieldData> {
    public abstract NumericType getNumericType();

    public final SortField sortField(NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        IndexFieldData.XFieldComparatorSource source = this.comparatorSource(targetNumericType, missingValue, sortMode, nested);
        if (this.sortRequiresCustomComparator() || nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || targetNumericType != this.getNumericType()) {
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), this.getNumericType().sortFieldType, reverse, selectorType);
        sortField.setMissingValue(source.missingObject(missingValue, reverse));
        return sortField;
    }

    protected abstract boolean sortRequiresCustomComparator();

    @Override
    public final SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    @Override
    public final SortField wideSortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        if (this.getNumericType().sortFieldType == SortField.Type.INT) {
            IndexFieldData.XFieldComparatorSource source = this.comparatorSource(NumericType.LONG, missingValue, sortMode, nested);
            SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
            SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), SortField.Type.LONG, reverse, selectorType);
            sortField.setMissingValue(source.missingObject(missingValue, reverse));
            return sortField;
        }
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    public final BucketedSort newBucketedSort(NumericType targetNumericType, BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.comparatorSource(targetNumericType, missingValue, sortMode, nested).newBucketedSort(bigArrays, sortOrder, format, bucketSize, extra);
    }

    @Override
    public final BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.newBucketedSort(this.getNumericType(), bigArrays, missingValue, sortMode, nested, sortOrder, format, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource comparatorSource(NumericType targetNumericType, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        IndexFieldData.XFieldComparatorSource source = switch (targetNumericType.ordinal()) {
            case 7 -> new HalfFloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 8 -> new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 9 -> new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
            case 10 -> new UnsignedLongValuesComparatorSource(this, missingValue, sortMode, nested);
            case 5 -> this.dateComparatorSource(missingValue, sortMode, nested);
            case 6 -> this.dateNanosComparatorSource(missingValue, sortMode, nested);
            case 4 -> new LongValuesComparatorSource(this, missingValue, sortMode, nested);
            default -> {
                if (!$assertionsDisabled && targetNumericType.isFloatingPoint()) {
                    throw new AssertionError();
                }
                yield new IntValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        };
        if (targetNumericType != this.getNumericType()) {
            source.disableSkipping();
        }
        return source;
    }

    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> IndexNumericFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds));
    }

    protected static SortedNumericDocValues convertNumeric(final SortedNumericDocValues values, final LongUnaryOperator converter) {
        return new AbstractSortedNumericDocValues(){

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }
        };
    }

    public static enum NumericType {
        BOOLEAN(false, SortField.Type.INT, CoreValuesSourceType.BOOLEAN),
        BYTE(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        SHORT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        INT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        DATE(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        DATE_NANOSECONDS(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        HALF_FLOAT(true, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        DOUBLE(true, SortField.Type.DOUBLE, CoreValuesSourceType.NUMERIC),
        UNSIGNED_LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC);

        private final boolean floatingPoint;
        private final ValuesSourceType valuesSourceType;
        private final SortField.Type sortFieldType;

        private NumericType(boolean floatingPoint, SortField.Type sortFieldType, ValuesSourceType valuesSourceType) {
            this.floatingPoint = floatingPoint;
            this.sortFieldType = sortFieldType;
            this.valuesSourceType = valuesSourceType;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final ValuesSourceType getValuesSourceType() {
            return this.valuesSourceType;
        }
    }
}

