/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.autotagging;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rule.MatchLabel;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.storage.AttributeValueStore;

public interface Attribute
extends Writeable {
    public String getName();

    default public Map<String, Float> getWeightedSubfields() {
        return new HashMap<String, Float>();
    }

    default public void validateAttribute() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
    }

    default public Set<String> fromXContentParseAttributeValues(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected START_ARRAY token for " + this.getName() + " attribute but got " + String.valueOf(parser.currentToken()));
        }
        HashSet<String> attributeValueSet = new HashSet<String>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                attributeValueSet.add(parser.text());
                continue;
            }
            throw new XContentParseException("Unexpected token in array: " + String.valueOf(parser.currentToken()));
        }
        return attributeValueSet;
    }

    default public void toXContentWriteAttributeValues(XContentBuilder builder, Set<String> values) throws IOException {
        builder.array(this.getName(), values.toArray(new String[0]));
    }

    public static Attribute from(StreamInput in, FeatureType featureType) throws IOException {
        String attributeName = in.readString();
        Attribute attribute = featureType.getAttributeFromName(attributeName);
        if (attribute == null) {
            throw new IllegalStateException(attributeName + " is not a valid attribute under feature type " + featureType.getName());
        }
        return attribute;
    }

    default public List<MatchLabel<String>> findAttributeMatches(AttributeExtractor<String> attributeExtractor, AttributeValueStore<String, String> attributeValueStore) {
        HashMap<String, Float> scoreMap = new HashMap<String, Float>();
        for (String value : attributeExtractor.extract()) {
            List<MatchLabel<String>> matches = attributeValueStore.getMatches(value);
            for (MatchLabel<String> entry : matches) {
                scoreMap.merge(entry.getFeatureValue(), Float.valueOf(entry.getMatchScore()), Float::sum);
            }
        }
        return scoreMap.entrySet().stream().map(e -> new MatchLabel<String>((String)e.getKey(), ((Float)e.getValue()).floatValue())).sorted((a, b) -> Float.compare(b.getMatchScore(), a.getMatchScore())).collect(Collectors.toList());
    }
}

