/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.NestedSortValue;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

class NestedSortProtoUtils {
    private NestedSortProtoUtils() {
    }

    static NestedSortBuilder fromProto(NestedSortValue nestedSortValue, QueryBuilderProtoConverterRegistry registry) {
        if (nestedSortValue == null) {
            throw new IllegalArgumentException("NestedSortValue cannot be null");
        }
        String path = nestedSortValue.getPath();
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path is required for nested sort");
        }
        QueryBuilder filter = null;
        int maxChildren = Integer.MAX_VALUE;
        NestedSortBuilder nestedSort = null;
        if (nestedSortValue.hasFilter()) {
            if (registry == null) {
                throw new IllegalStateException("QueryBuilderProtoConverterRegistry cannot be null.");
            }
            try {
                filter = registry.fromProto(nestedSortValue.getFilter());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert nested sort filter: " + e.getMessage(), e);
            }
        }
        if (nestedSortValue.hasMaxChildren()) {
            maxChildren = nestedSortValue.getMaxChildren();
        }
        if (nestedSortValue.hasNested()) {
            nestedSort = NestedSortProtoUtils.fromProto(nestedSortValue.getNested(), registry);
        }
        return new NestedSortBuilder(path).setFilter(filter).setMaxChildren(maxChildren).setNestedSort(nestedSort);
    }
}

