/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog.add_download;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.add_download.DialogAddDownloadWithCoroutines;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilenameUtils;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.configuration2.Configuration;
import org.jdesktop.swingx.VerticalLayout;

public class DialogAddMoreDownload
extends JDialog {
    private final DatenPset pSet;
    private final String orgPfad;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private boolean addAll;
    private boolean cancel;
    private boolean info;
    private boolean subtitle;
    private boolean startImmediately;
    private JComboBox<String> jComboBoxPath;
    private JButton jButtonDelPath;
    private JButton jButtonPath;
    private JCheckBox chkInfo;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox chkSubtitle;
    private JButton btnChange;
    private JButton btnCancel;
    private JButton btnStartImmediately;
    private JButton btnQueueDownloads;

    public DialogAddMoreDownload(JFrame parent, DatenPset pSet) {
        super(parent);
        this.pSet = pSet;
        this.initComponents();
        this.chkSubtitle.setSelected(Boolean.parseBoolean(pSet.arr[21]));
        this.subtitle = this.chkSubtitle.isSelected();
        this.chkSubtitle.addActionListener(actionEvent -> {
            this.subtitle = this.chkSubtitle.isSelected();
        });
        this.chkInfo.setSelected(Boolean.parseBoolean(pSet.arr[19]));
        this.info = this.chkInfo.isSelected();
        this.chkInfo.addActionListener(actionEvent -> {
            this.info = this.chkInfo.isSelected();
        });
        this.jCheckBoxPfadSpeichern.setSelected(this.config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(actionEvent -> this.config.setProperty("download.path.last_used.show", (Object)this.jCheckBoxPfadSpeichern.isSelected()));
        this.btnChange.addActionListener(actionEvent -> this.dispose());
        this.btnStartImmediately.addActionListener(actionEvent -> {
            this.addAll = true;
            this.startImmediately = true;
            this.dispose();
        });
        this.btnQueueDownloads.addActionListener(actionEvent -> {
            this.addAll = true;
            this.startImmediately = false;
            this.dispose();
        });
        this.btnCancel.addActionListener(actionEvent -> {
            this.cancel = true;
            this.dispose();
        });
        this.jButtonPath.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonPath.addActionListener(actionEvent -> {
            File selectedDirectory;
            String initialDirectory = "";
            String cbItem = Objects.requireNonNull(this.jComboBoxPath.getSelectedItem()).toString();
            if (!cbItem.isEmpty()) {
                initialDirectory = cbItem;
            }
            if ((selectedDirectory = FileDialogs.chooseDirectoryLocation(MediathekGui.ui(), "Film speichern", initialDirectory)) != null) {
                String absolutePath = selectedDirectory.getAbsolutePath();
                this.jComboBoxPath.addItem(absolutePath);
                this.jComboBoxPath.setSelectedItem(absolutePath);
            }
        });
        this.jButtonDelPath.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.jButtonDelPath.addActionListener(actionEvent -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{pSet.getZielPfad()}));
        });
        DialogAddDownloadWithCoroutines.setModelPfad(pSet.getZielPfad(), this.jComboBoxPath);
        this.orgPfad = pSet.getZielPfad();
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new IllegalFilenameListener());
        EscapeKeyHandler.installHandler(this, () -> {
            this.cancel = true;
            this.dispose();
        });
        this.getRootPane().setDefaultButton(this.btnStartImmediately);
        this.pack();
    }

    public boolean wasCancelled() {
        return this.cancel;
    }

    public DialogResult showDialog() {
        this.setVisible(true);
        return new DialogResult(this.addAll, this.info, this.subtitle, this.getPath(), this.startImmediately);
    }

    private String getPath() {
        String path = this.jComboBoxPath.getModel().getSelectedItem().toString();
        if (path.isEmpty()) {
            path = this.pSet.getZielPfad();
        }
        return path;
    }

    @Override
    public void dispose() {
        DialogAddDownloadWithCoroutines.saveComboPfad(this.jComboBoxPath, this.orgPfad);
        super.dispose();
    }

    private void initComponents() {
        JPanel jPanelExtra = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jComboBoxPath = new JComboBox();
        this.jButtonDelPath = new JButton();
        this.jButtonPath = new JButton();
        JPanel jPanel1 = new JPanel();
        this.chkInfo = new JCheckBox();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.chkSubtitle = new JCheckBox();
        this.btnChange = new JButton();
        this.btnCancel = new JButton();
        this.btnStartImmediately = new JButton();
        this.btnQueueDownloads = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Alle Downloads starten");
        this.setModal(true);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        jPanelExtra.setBorder(new EtchedBorder());
        jLabel1.setText("Speicherpfad:");
        this.jComboBoxPath.setEditable(true);
        this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jButtonDelPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonDelPath.setToolTipText("History l\u00f6schen");
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonPath.setToolTipText("Zielpfad ausw\u00e4hlen");
        jPanel1.setLayout((LayoutManager)new VerticalLayout(5));
        this.chkInfo.setText("Infodatei anlegen: \"Filmname.txt\"");
        jPanel1.add(this.chkInfo);
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        jPanel1.add(this.jCheckBoxPfadSpeichern);
        this.chkSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        jPanel1.add(this.chkSubtitle);
        GroupLayout jPanelExtraLayout = new GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jComboBoxPath, -2, 450, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE).addComponent(this.jButtonDelPath)).addComponent(jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jComboBoxPath, -2, -1, -2).addComponent(this.jButtonDelPath).addComponent(this.jButtonPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnChange.setText("Einzeln anlegen");
        this.btnChange.setToolTipText("Die Sammelaktion wird abgebrochen und Sie k\u00f6nnen im Anschlu\u00df die Einstellungen f\u00fcr jeden Download einzeln festlegen.");
        this.btnCancel.setText("Abbrechen");
        this.btnStartImmediately.setText("Sofort starten");
        this.btnQueueDownloads.setText("In die Warteschlange");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addGroup(contentPaneLayout.createParallelGroup().addComponent(jPanelExtra, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.btnChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 177, Short.MAX_VALUE).addComponent(this.btnQueueDownloads).addGap(18, 18, 18).addComponent(this.btnStartImmediately).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jPanelExtra, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnStartImmediately).addComponent(this.btnQueueDownloads).addComponent(this.btnChange)).addContainerGap(7, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class IllegalFilenameListener
    implements DocumentListener {
        private IllegalFilenameListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            String s = ((JTextComponent)DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent()).getText();
            Component editor = DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent();
            if (!s.equals(FilenameUtils.checkFilenameForIllegalCharacters(s, true))) {
                editor.setBackground(MVColor.DOWNLOAD_FEHLER.color);
            } else {
                editor.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
    }

    public record DialogResult(boolean addAllWithDefaults, boolean info, boolean subtitle, String path, boolean startImmediately) {
    }
}

