/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.UnsupportedEncodingException;

class PerfDataType {
    private final String name;
    private final byte value;
    private final int size;
    public static final PerfDataType BOOLEAN = new PerfDataType("boolean", "Z", 1);
    public static final PerfDataType CHAR = new PerfDataType("char", "C", 1);
    public static final PerfDataType FLOAT = new PerfDataType("float", "F", 8);
    public static final PerfDataType DOUBLE = new PerfDataType("double", "D", 8);
    public static final PerfDataType BYTE = new PerfDataType("byte", "B", 1);
    public static final PerfDataType SHORT = new PerfDataType("short", "S", 2);
    public static final PerfDataType INT = new PerfDataType("int", "I", 4);
    public static final PerfDataType LONG = new PerfDataType("long", "J", 8);
    public static final PerfDataType ILLEGAL = new PerfDataType("illegal", "X", 0);
    private static PerfDataType[] basicTypes = new PerfDataType[]{LONG, BYTE, BOOLEAN, CHAR, FLOAT, DOUBLE, SHORT, INT};

    public String toString() {
        return this.name;
    }

    public byte byteValue() {
        return this.value;
    }

    public int size() {
        return this.size;
    }

    public static PerfDataType toPerfDataType(byte by) {
        for (int i = 0; i < basicTypes.length; ++i) {
            if (basicTypes[i].byteValue() != by) continue;
            return basicTypes[i];
        }
        return ILLEGAL;
    }

    private PerfDataType(String string, String string2, int n) {
        this.name = string;
        this.size = n;
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            this.value = byArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unknown encoding", unsupportedEncodingException);
        }
    }
}

