/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jmol.api.SC;
import org.jmol.awt.AwtSwingComponent;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupHelper;

public class AwtPopupHelper
implements ActionListener,
ItemListener,
MouseListener,
PopupHelper {
    private GenericPopup popup;
    private Map<Object, SC> htSources = new Hashtable<Object, SC>();
    private ButtonGroup buttonGroup;

    public AwtPopupHelper(GenericPopup popup) {
        this.popup = popup;
    }

    public SC menuCreatePopup(String title, Object applet) {
        return AwtSwingComponent.getPopup(title, this.htSources);
    }

    public SC getRadio(String name) {
        return AwtSwingComponent.getRadio(this, name, this.htSources);
    }

    public SC getCheckBox(String name) {
        return AwtSwingComponent.getCheckBox(this, name, this.htSources);
    }

    public SC getMenu(String name) {
        return AwtSwingComponent.getMenu(name, this.htSources);
    }

    public SC getMenuItem(String name) {
        return AwtSwingComponent.getMenuItem(this, name, this.htSources);
    }

    public void menuAddButtonGroup(SC item) {
        if (item == null) {
            if (this.buttonGroup != null && this.buttonGroup.getButtonCount() > 0) {
                this.buttonGroup = null;
            }
            return;
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        this.buttonGroup.add(((AwtSwingComponent)item).ab);
    }

    public Object getButtonGroup() {
        return this.buttonGroup;
    }

    public void menuInsertSubMenu(SC menu, SC subMenu, int index) {
        menu.insert(subMenu, index);
    }

    public int getItemType(SC m) {
        if (m == null) {
            return 0;
        }
        JComponent jc = ((AwtSwingComponent)m).jc;
        return jc instanceof JMenu ? 4 : (jc instanceof JRadioButtonMenuItem ? 3 : (jc instanceof JCheckBoxMenuItem ? 2 : (m.getText() != null ? 1 : 0)));
    }

    public SC getSwingComponent(Object component) {
        return component == null ? null : this.htSources.get(component);
    }

    public void menuClearListeners(SC c) {
        if (c == null) {
            return;
        }
        this.clearListeners(c.getComponents());
        this.clearListener(((AwtSwingComponent)c).ab);
    }

    private void clearListener(AbstractButton ab) {
        if (ab != null) {
            try {
                ab.removeMouseListener(this);
                ab.removeActionListener(this);
                ab.removeItemListener(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearListeners(Object[] subMenus) {
        for (int i = 0; i < subMenus.length; ++i) {
            JComponent m = (JComponent)subMenus[i];
            if (!(m instanceof JMenu)) continue;
            this.clearListeners(m.getComponents());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.popup.menuCheckBoxCallback(this.getSource(e));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.popup.menuClickCallback(this.getSource(e), e.getActionCommand());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem jmi = (JMenuItem)e.getSource();
            this.popup.menuFocusCallback(jmi.getName(), jmi.getActionCommand(), true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem jmi = (JMenuItem)e.getSource();
            this.popup.menuFocusCallback(jmi.getName(), jmi.getActionCommand(), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private SC getSource(EventObject e) {
        return this.getSwingComponent(e.getSource());
    }

    public void reinstateMenu(JMenuItem item, MenuElement[] path) {
        String name = "" + item.getName();
        if (name.indexOf("Persist") >= 0 && name.indexOf("!Persist") < 0) {
            this.popup.jpiShow(this.popup.thisx, this.popup.thisy);
            MenuSelectionManager.defaultManager().setSelectedPath(path);
        }
    }

    public void dispose(SC popupMenu) {
        this.menuClearListeners(popupMenu);
        this.popup = null;
    }
}

