/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.function.Supplier;
import org.gradle.internal.classpath.InstrumentableClosure;
import org.gradle.internal.classpath.InstrumentedClosuresTracker;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PerThreadInstrumentedClosuresTracker
implements InstrumentedClosuresTracker {
    private final ThreadLocal<InstrumentedClosuresTracker> perThreadTracker;

    public PerThreadInstrumentedClosuresTracker(Supplier<InstrumentedClosuresTracker> trackerForThread) {
        this.perThreadTracker = ThreadLocal.withInitial(trackerForThread);
    }

    @Override
    public void enterClosure(InstrumentableClosure thisClosure) {
        this.perThreadTracker.get().enterClosure(thisClosure);
    }

    @Override
    public void leaveClosure(InstrumentableClosure thisClosure) {
        this.perThreadTracker.get().leaveClosure(thisClosure);
    }

    @Override
    public void hitInstrumentedDynamicCall() {
        this.perThreadTracker.get().hitInstrumentedDynamicCall();
    }
}

