/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileNoticeLifeCycleListener
implements LifeCycle.Listener {
    private static final Logger LOG = Log.getLogger(FileNoticeLifeCycleListener.class);
    private final String _filename;

    public FileNoticeLifeCycleListener(String filename) {
        this._filename = filename;
    }

    private void writeState(String action, LifeCycle lifecycle) {
        try (FileWriter out = new FileWriter(this._filename, true);){
            ((Writer)out).append(action).append(" ").append(lifecycle.toString()).append("\n");
        }
        catch (Exception e2) {
            LOG.warn(e2);
        }
    }

    @Override
    public void lifeCycleStarting(LifeCycle event2) {
        this.writeState("STARTING", event2);
    }

    @Override
    public void lifeCycleStarted(LifeCycle event2) {
        this.writeState("STARTED", event2);
    }

    @Override
    public void lifeCycleFailure(LifeCycle event2, Throwable cause) {
        this.writeState("FAILED", event2);
    }

    @Override
    public void lifeCycleStopping(LifeCycle event2) {
        this.writeState("STOPPING", event2);
    }

    @Override
    public void lifeCycleStopped(LifeCycle event2) {
        this.writeState("STOPPED", event2);
    }
}

