/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.UnsignedType;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.runtime.rtti.BasicSqlTypeRtti;
import org.apache.calcite.runtime.rtti.RowSqlTypeRtti;
import org.apache.calcite.runtime.rtti.RuntimeTypeInformation;
import org.apache.calcite.runtime.variant.VariantSqlValue;
import org.apache.calcite.runtime.variant.VariantValue;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joou.UByte;
import org.joou.UInteger;
import org.joou.ULong;
import org.joou.UShort;

public class VariantNonNull
extends VariantSqlValue {
    final RoundingMode roundingMode;
    final Object value;

    VariantNonNull(RoundingMode roundingMode, Object value, RuntimeTypeInformation runtimeType) {
        super(runtimeType.getTypeName());
        this.roundingMode = roundingMode;
        switch (runtimeType.getTypeName()) {
            case UUID: {
                assert (value instanceof UUID);
                this.value = value;
                break;
            }
            case NAME: {
                assert (value instanceof String);
                this.value = value;
                break;
            }
            case BOOLEAN: {
                assert (value instanceof Boolean);
                this.value = value;
                break;
            }
            case TINYINT: {
                assert (value instanceof Byte);
                this.value = value;
                break;
            }
            case UTINYINT: {
                assert (value instanceof UByte);
                this.value = value;
                break;
            }
            case SMALLINT: {
                assert (value instanceof Short);
                this.value = value;
                break;
            }
            case USMALLINT: {
                assert (value instanceof UShort);
                this.value = value;
                break;
            }
            case INTEGER: {
                assert (value instanceof Integer);
                this.value = value;
                break;
            }
            case UINTEGER: {
                assert (value instanceof UInteger);
                this.value = value;
                break;
            }
            case BIGINT: {
                assert (value instanceof Long);
                this.value = value;
                break;
            }
            case UBIGINT: {
                assert (value instanceof ULong);
                this.value = value;
                break;
            }
            case DECIMAL: {
                assert (value instanceof BigDecimal);
                this.value = value;
                break;
            }
            case REAL: {
                assert (value instanceof Float);
                this.value = value;
                break;
            }
            case DOUBLE: {
                assert (value instanceof Double);
                this.value = value;
                break;
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME_TZ: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_TZ: 
            case INTERVAL_LONG: 
            case INTERVAL_SHORT: {
                this.value = value;
                break;
            }
            case VARCHAR: {
                this.value = value;
                assert (value instanceof String);
                break;
            }
            default: {
                throw new RuntimeException("Unreachable");
            }
            case VARBINARY: 
            case GEOMETRY: 
            case VARIANT: {
                this.value = value;
                break;
            }
            case MAP: {
                RuntimeTypeInformation keyType = runtimeType.asGeneric().getTypeArgument(0);
                RuntimeTypeInformation valueType = runtimeType.asGeneric().getTypeArgument(1);
                assert (value instanceof Map);
                Map map = (Map)value;
                LinkedHashMap<VariantValue, VariantValue> converted = new LinkedHashMap<VariantValue, VariantValue>(map.size());
                for (Map.Entry o : map.entrySet()) {
                    VariantValue key = VariantSqlValue.create(roundingMode, o.getKey(), keyType);
                    VariantValue val = VariantSqlValue.create(roundingMode, o.getValue(), valueType);
                    converted.put(key, val);
                }
                this.value = converted;
                break;
            }
            case ROW: {
                assert (value instanceof Object[]);
                Object[] a = (Object[])value;
                assert (runtimeType instanceof RowSqlTypeRtti);
                RowSqlTypeRtti rowType = (RowSqlTypeRtti)runtimeType;
                LinkedHashMap<VariantValue, VariantValue> converted = new LinkedHashMap<VariantValue, VariantValue>(a.length);
                BasicSqlTypeRtti name = new BasicSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName.NAME);
                for (int i = 0; i < a.length; ++i) {
                    Map.Entry<String, RuntimeTypeInformation> fieldType = rowType.getField(i);
                    VariantValue key = VariantSqlValue.create(roundingMode, fieldType.getKey(), name);
                    VariantValue val = VariantSqlValue.create(roundingMode, a[i], fieldType.getValue());
                    converted.put(key, val);
                }
                this.value = converted;
                break;
            }
            case MULTISET: 
            case ARRAY: {
                RuntimeTypeInformation elementType = runtimeType.asGeneric().getTypeArgument(0);
                assert (value instanceof List);
                List list = (List)value;
                ArrayList<VariantValue> converted = new ArrayList<VariantValue>(list.size());
                for (Object o : list) {
                    VariantValue element = VariantSqlValue.create(roundingMode, o, elementType);
                    converted.add(element);
                }
                this.value = converted;
                break;
            }
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantNonNull variant = (VariantNonNull)o;
        return Objects.equals(this.value, variant.value) && this.runtimeType == variant.runtimeType;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.value);
        result = 31 * result + this.runtimeType.hashCode();
        return result;
    }

    @Override
    public @Nullable Object cast(RuntimeTypeInformation type) {
        if (this.runtimeType.isScalar()) {
            if (this.runtimeType == type.getTypeName()) {
                return this.value;
            }
            @Nullable Primitive target = type.asPrimitive();
            switch (this.runtimeType) {
                case TINYINT: {
                    byte b = (Byte)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)b, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(b);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((byte)b);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((byte)b);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((byte)b);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((byte)b);
                        }
                    }
                    break;
                }
                case SMALLINT: {
                    short s = (Short)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)s, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(s);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((short)s);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((short)s);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((short)s);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((short)s);
                        }
                    }
                    break;
                }
                case INTEGER: {
                    int i = (Integer)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)i, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(i);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((int)i);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((int)i);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((int)i);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((int)i);
                        }
                    }
                    break;
                }
                case BIGINT: {
                    long l = ((Integer)this.value).intValue();
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)l, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(l);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((long)l);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((long)l);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((long)l);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((long)l);
                        }
                    }
                    break;
                }
                case DECIMAL: {
                    BigDecimal d = (BigDecimal)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)d, this.roundingMode);
                        }
                        case DECIMAL: {
                            return d;
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((long)d.longValueExact());
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((long)d.longValueExact());
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((long)d.longValueExact());
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((long)d.longValueExact());
                        }
                    }
                    break;
                }
                case REAL: {
                    float f = ((Float)this.value).floatValue();
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)Float.valueOf(f), this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(f);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((float)f);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((float)f);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((float)f);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((float)f);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double d = (Double)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)d, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(d);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((double)d);
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((double)d);
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((double)d);
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((double)d);
                        }
                    }
                    break;
                }
                case UTINYINT: {
                    UByte b = (UByte)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)b, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(b.intValue());
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((int)b.intValue());
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((int)b.intValue());
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((int)b.intValue());
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((int)b.intValue());
                        }
                    }
                    break;
                }
                case USMALLINT: {
                    UShort s = (UShort)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)s, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(s.intValue());
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((int)s.intValue());
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((int)s.intValue());
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((int)s.intValue());
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((int)s.intValue());
                        }
                    }
                    break;
                }
                case UINTEGER: {
                    UInteger b = (UInteger)this.value;
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)b, this.roundingMode);
                        }
                        case DECIMAL: {
                            return BigDecimal.valueOf(b.longValue());
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((long)b.longValue());
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((long)b.longValue());
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((long)b.longValue());
                        }
                        case UBIGINT: {
                            return UnsignedType.toULong((long)b.longValue());
                        }
                    }
                    break;
                }
                case UBIGINT: {
                    BigInteger i = UnsignedType.toBigInteger((ULong)((ULong)this.value));
                    switch (type.getTypeName()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case REAL: 
                        case DOUBLE: {
                            return Objects.requireNonNull(target, "target").numberValue((Number)i, this.roundingMode);
                        }
                        case DECIMAL: {
                            return new BigDecimal(i);
                        }
                        case UTINYINT: {
                            return UnsignedType.toUByte((long)i.longValueExact());
                        }
                        case USMALLINT: {
                            return UnsignedType.toUShort((long)i.longValueExact());
                        }
                        case UINTEGER: {
                            return UnsignedType.toUInteger((long)i.longValueExact());
                        }
                        case UBIGINT: {
                            return this.value;
                        }
                    }
                    break;
                }
            }
            return null;
        }
        switch (this.runtimeType) {
            case ARRAY: {
                if (type.getTypeName() != RuntimeTypeInformation.RuntimeSqlTypeName.ARRAY) break;
                RuntimeTypeInformation elementType = type.asGeneric().getTypeArgument(0);
                assert (this.value instanceof List);
                List list = (List)this.value;
                ArrayList<@Nullable Object> result = new ArrayList<Object>(list.size());
                for (VariantSqlValue o : list) {
                    @Nullable Object converted = o.cast(elementType);
                    result.add(converted);
                }
                return result;
            }
            case MAP: {
                assert (this.value instanceof Map);
                Map map = (Map)this.value;
                if (type.getTypeName() == RuntimeTypeInformation.RuntimeSqlTypeName.MAP) {
                    RuntimeTypeInformation keyType = type.asGeneric().getTypeArgument(0);
                    RuntimeTypeInformation valueType = type.asGeneric().getTypeArgument(0);
                    LinkedHashMap<@Nullable Object, @Nullable Object> result = new LinkedHashMap<Object, Object>(map.size());
                    for (Map.Entry e : map.entrySet()) {
                        @Nullable Object key = ((VariantSqlValue)e.getKey()).cast(keyType);
                        @Nullable Object value = ((VariantSqlValue)e.getValue()).cast(valueType);
                        result.put(key, value);
                    }
                    return result;
                }
                if (type.getTypeName() != RuntimeTypeInformation.RuntimeSqlTypeName.ROW) break;
                RowSqlTypeRtti rowType = (RowSqlTypeRtti)type;
                @Nullable Object[] result = new Object[rowType.size()];
                for (int i = 0; i < rowType.size(); ++i) {
                    Map.Entry<String, RuntimeTypeInformation> field = rowType.getField(i);
                    Object fieldValue = null;
                    VariantValue v = this.item(field.getKey());
                    if (v != null) {
                        fieldValue = v.cast(field.getValue());
                    }
                    result[i] = fieldValue;
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public @Nullable VariantValue item(Object index) {
        Object result;
        boolean isInteger = index instanceof Integer;
        switch (this.runtimeType) {
            case ROW: {
                if (!(index instanceof String)) break;
                BasicSqlTypeRtti string = new BasicSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName.NAME);
                index = VariantSqlValue.create(this.roundingMode, index, string);
                break;
            }
            case MAP: {
                BasicSqlTypeRtti string;
                if (index instanceof String) {
                    string = new BasicSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName.VARCHAR);
                    index = VariantSqlValue.create(this.roundingMode, index, string);
                    break;
                }
                if (!isInteger) break;
                BasicSqlTypeRtti i = new BasicSqlTypeRtti(RuntimeTypeInformation.RuntimeSqlTypeName.INTEGER);
                index = VariantSqlValue.create(this.roundingMode, index, i);
                break;
            }
            case ARRAY: {
                if (isInteger) break;
                return null;
            }
            default: {
                return null;
            }
        }
        if ((result = SqlFunctions.itemOptional(this.value, index)) == null) {
            return null;
        }
        if (result instanceof VariantValue) {
            return (VariantValue)result;
        }
        return null;
    }

    public String toString() {
        if (this.runtimeType == RuntimeTypeInformation.RuntimeSqlTypeName.ROW && this.value instanceof Map) {
            Map map = (Map)this.value;
            StringBuilder buf = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry o : map.entrySet()) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                if (o.getValue() == null) continue;
                buf.append(o.getValue());
            }
            buf.append("}");
            return buf.toString();
        }
        String quote = "";
        switch (this.runtimeType) {
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME_TZ: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_TZ: 
            case INTERVAL_LONG: 
            case INTERVAL_SHORT: 
            case VARCHAR: 
            case VARBINARY: {
                quote = "\"";
                break;
            }
        }
        return quote + this.value + quote;
    }
}

