/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.DsaKCalculator;
import org.bouncycastle.crypto.fips.RandomDsaKCalculator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.DsaKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DsaSigner
implements DSA {
    private final DsaKCalculator kCalculator;
    private DsaKeyParameters key;
    private SecureRandom random;

    public DsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public DsaSigner(DsaKCalculator dsaKCalculator) {
        this.kCalculator = dsaKCalculator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (!(cipherParameters instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            this.key = (DsaPrivateKeyParameters)parametersWithRandom.getParameters();
            return;
        } else {
            this.key = (DsaPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger = dsaParameters.getQ();
        BigInteger bigInteger2 = this.calculateE(bigInteger, byArray);
        BigInteger bigInteger3 = ((DsaPrivateKeyParameters)this.key).getX();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(bigInteger, bigInteger3, byArray);
        } else {
            this.kCalculator.init(bigInteger, this.random);
        }
        BigInteger bigInteger4 = this.kCalculator.nextK();
        BigInteger bigInteger5 = dsaParameters.getG().modPow(bigInteger4.add(this.getRandomizer(bigInteger, this.random)), dsaParameters.getP()).mod(bigInteger);
        bigInteger4 = BigIntegers.modOddInverse(bigInteger, bigInteger4).multiply(bigInteger2.add(bigInteger3.multiply(bigInteger5)));
        BigInteger bigInteger6 = bigInteger4.mod(bigInteger);
        return new BigInteger[]{bigInteger5, bigInteger6};
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger3 = dsaParameters.getQ();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        BigInteger bigInteger5 = BigInteger.valueOf(0L);
        if (bigInteger5.compareTo(bigInteger) >= 0 || bigInteger3.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger5.compareTo(bigInteger2) >= 0 || bigInteger3.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger6 = BigIntegers.modOddInverseVar(bigInteger3, bigInteger2);
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger6).mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger.multiply(bigInteger6).mod(bigInteger3);
        bigInteger7 = dsaParameters.getG().modPow(bigInteger7, dsaParameters.getP());
        bigInteger8 = ((DsaPublicKeyParameters)this.key).getY().modPow(bigInteger8, dsaParameters.getP());
        BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(dsaParameters.getP()).mod(bigInteger3);
        return bigInteger9.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    private BigInteger getRandomizer(BigInteger bigInteger, SecureRandom secureRandom) {
        int n = 7;
        return new BigInteger(n, secureRandom).add(BigInteger.valueOf(128L)).multiply(bigInteger);
    }
}

