/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { TranslatedString } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { FormDesign } from "../forms-types.js";
import { DefaultForm as TestedComponent } from "../forms-ui.js";

export default {
  title: "Input Select Multiple",
};

export namespace Simplest {
  export interface Form {
    comment: string;
  }
}

type TargetObject = {
  pets: string[];
  things: string[];
};
const initial: TargetObject = {
  pets: [],
  things: [],
};

const design: FormDesign = {
  type: "double-column",
  sections: [
    {
      title: "this is a simple form" as TranslatedString,
      fields: [
        {
          type: "selectMultiple",
          label: "allow duplicates" as TranslatedString,
          help: "this is a help text" as TranslatedString,
          id: "pets",
          placeholder: "search..." as TranslatedString,
          choices: [
            {
              label: "one label" as TranslatedString,
              value: "one",
            },
            {
              label: "two label" as TranslatedString,
              value: "two",
            },
            {
              label: "five label" as TranslatedString,
              value: "five",
            },
          ],
        },
        {
          type: "selectMultiple",
          label: "unique values" as TranslatedString,
          id: "things",
          unique: true,
          placeholder: "search..." as TranslatedString,
          choices: [
            {
              label: "one label" as TranslatedString,
              value: "one",
            },
            {
              label: "two label" as TranslatedString,
              value: "two",
            },
            {
              label: "five label" as TranslatedString,
              value: "five",
            },
          ],
        },
      ],
    },
  ],
};

export const SimpleComment = tests.createExample(TestedComponent, {
  initial,
  design,
});
export const WithInitialValue = tests.createExample(TestedComponent, {
  initial: {
    pets:["one"]
  },
  design,
});
