/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_report_status.h
 * @brief implementation of the update_report_status function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_REPORT_STATUS_H
#define PG_UPDATE_REPORT_STATUS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update transmission status about a particular report.
 *
 * @param cls closure
 * @param instance_id instance to update report for
 * @param report_id serial number of the pot to update
 * @param next_tranmission when should the report be generated next
 * @param last_error_code #TALER_EC_NONE on success
 * @param last_error_detail NULL on success
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_report_status (
  void *cls,
  const char *instance_id,
  uint64_t report_id,
  struct GNUNET_TIME_Timestamp next_transmission,
  enum TALER_ErrorCode last_error_code,
  const char *last_error_detail);


#endif
