/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_order_blinded_sigs.h
 * @brief Implementation of the select blinded sigs by order_id function for Postgres
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_SELECT_BLIND_SIGS_ORD_H
#define PG_SELECT_BLIND_SIGS_ORD_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Look up the Donau *blinded‐signature* blob we already stored for an
 * order (identified by its human-readable `order_id`) and hand it back
 * to the caller.
 *
 * @param cls closure (our `struct PostgresClosure *`)
 * @param order_id business-level order identifier
 * @param cb callback to be called with the blinded signature and hash
 * @param cb_cls callback closure
 * @return GNUNET_DB status code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_order_blinded_sigs (
  void *cls,
  const char *order_id,
  TALER_MERCHANTDB_BlindedSigCallback cb,
  void *cb_cls);

#endif
