#line 559 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "telinit.opt"
/* This file is part of GNU Pies. -*- c -*-
   Copyright (C) 2016-2025 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#line 50 "telinit.opt"
#ifdef HAVE_CONFIG_H
#line 50
# include <config.h>
#line 50
#endif
#line 50
#ifdef HAVE_GETOPT_H
#line 50
# include <getopt.h>
#line 50
#endif
#line 50
#include <unistd.h>
#line 50
#include <stdlib.h>
#line 50
#include <grecs.h>
#line 50
#include <grecs/opt.h>
#line 50
#ifndef EX_USAGE
#line 50
# define EX_USAGE 64
#line 50
#endif
#line 50
/* Option codes */
#line 50
enum {
#line 50
	_OPTION_INIT=255,
#line 50 "telinit.opt"
	OPTION_USAGE,
#line 50 "telinit.opt"
	MAX_OPTION
#line 50
};
#line 50
#ifdef HAVE_GETOPT_LONG
#line 50
static struct option long_options[] = {
#line 24 "telinit.opt"
	{ "timeout", required_argument, 0, 't' },
#line 37 "telinit.opt"
	{ "environment", required_argument, 0, 'e' },
#line 50 "telinit.opt"
	{ "help", no_argument, 0, 'h' },
#line 50 "telinit.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 50 "telinit.opt"
	{0, 0, 0, 0}
#line 50
};
#line 50
#endif
#line 50

#line 50
static struct grecs_opthelp opthelp[] = {
#line 26 "telinit.opt"
	{
#line 26
#ifdef HAVE_GETOPT_LONG
#line 26
	  "-t, --timeout",
#line 26
#else
#line 26
	  "-t",
#line 26
#endif
#line 26
				   N_("SECONDS"), 0, N_("set interval between sending TERM and KILL signals") },
#line 38 "telinit.opt"
	{
#line 38
#ifdef HAVE_GETOPT_LONG
#line 38
	  "-e, --environment",
#line 38
#else
#line 38
	  "-e",
#line 38
#endif
#line 38
				   N_("VAR=[VAL]"), 0, N_("change environment") },
#line 50 "telinit.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 50 "telinit.opt"
	{
#line 50
#ifdef HAVE_GETOPT_LONG
#line 50
	  "-h, --help",
#line 50
#else
#line 50
	  "-h",
#line 50
#endif
#line 50
				   NULL, 0, N_("Give this help list") },
#line 50 "telinit.opt"
	{
#line 50
#ifdef HAVE_GETOPT_LONG
#line 50
	  "--usage",
#line 50
#else
#line 50
	  "",
#line 50
#endif
#line 50
				   NULL, 0, N_("Give a short usage message") },
#line 50 "telinit.opt"
};
#line 17 "telinit.opt"

#line 17

#line 17
#ifndef PACKAGE_URL
#line 17
# define PACKAGE_URL NULL
#line 17
#endif
#line 17
static struct grecs_proginfo proginfo = {
#line 17
	"pies", /* progname */
#line 17
	NULL, /* subcommands */
#line 17
	N_("send command to init process via the legacy interface"), /* docstring */
#line 17
	N_("[RUNLEVEL]"), /* args_doc */
#line 17
	opthelp, /* opthelp */
#line 17
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 17
	NULL, /* print_help_hook */
#line 17
	NULL, /* print_version_hook */
#line 17
	PACKAGE_NAME,    /* package */
#line 17
	PACKAGE_VERSION, /* version */
#line 17
	NULL, /* license */
#line 17
NULL,/* copyright_year */
#line 17
NULL, /* copyright_holder */
#line 17
	NULL, /* *authors */
#line 17
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 17
	PACKAGE_URL, /* url */
#line 17
	NULL  /* epilogue */
#line 17
};
#line 17

#line 50 "telinit.opt"

#line 50


static void
telinit_parser (struct sysvinit_request *req, int argc, char *argv[])
{
  int i;
  char *cmds[] = { "-T", NULL };
  size_t envsize = 0;
  
  proginfo.subcmd = cmds;
  
#line 60
 {
#line 60
  int c;
#line 60

#line 60
  optind = 0;
#line 60
#ifdef HAVE_GETOPT_LONG
#line 60
  while ((c = getopt_long(argc, argv, "t:e:h",
#line 60
			  long_options, NULL)) != EOF)
#line 60
#else
#line 60
  while ((c = getopt(argc, argv, "t:e:h")) != EOF)
#line 60
#endif
#line 60
    {
#line 60
      switch (c)
#line 60
	{
#line 60
	default:
#line 60
	   	   exit(EX_USAGE);
#line 60
	#line 26 "telinit.opt"
	 case 't':
#line 26
	  {
#line 26

  char *p;
  errno = 0;
  shutdown_timeout = strtoul (optarg, &p, 0);
  if (*p || errno)
    {
      logmsg (LOG_ERR, _("invalid number: %s"), optarg);
      exit (EX_USAGE);
    }

#line 35
	     break;
#line 35
	  }
#line 38 "telinit.opt"
	 case 'e':
#line 38
	  {
#line 38

  size_t len = strlen (optarg);
  if (envsize + len + 2 > sizeof(req->data))
    {
      logmsg (LOG_ERR, _("-e argument too long"));
      exit (EX_USAGE);
    }
  memcpy (req->data + envsize, optarg, len);
  envsize += len;
  req->data[envsize++] = 0;

#line 48
	     break;
#line 48
	  }
#line 50 "telinit.opt"
	 case 'h':
#line 50
	  {
#line 50

#line 50
		grecs_print_help(&proginfo);
#line 50
		exit(0);
#line 50
	 
#line 50
	     break;
#line 50
	  }
#line 50 "telinit.opt"
	 case OPTION_USAGE:
#line 50
	  {
#line 50

#line 50
		grecs_print_usage(&proginfo);
#line 50
		exit(0);
#line 50
	 
#line 50
	     break;
#line 50
	  }

#line 60 "telinit.opt"
	}
#line 60
    }
#line 60
  i = optind;
#line 60
 }
#line 60
;
  argc -= i;
  argv += i;
  if (envsize)
    {
      req->data[envsize++] = 0;
      req->cmd = INIT_CMD_SETENV;
      if (argc)
	{
	  logmsg (LOG_ERR, _("too many arguments"));
	  exit (EX_USAGE);
	}
    }
  else
    {
      if (argc != 1)
	{
	  logmsg (LOG_ERR, _("bad number of arguments"));
	  exit (EX_USAGE);
	}
      if (argv[0][1] || !is_valid_runlevel (argv[0][0]))
	{
	  logmsg (LOG_ERR, _("invalid runlevel: %s"), argv[0]);
	  exit (EX_USAGE);
	}
      req->cmd = INIT_CMD_RUNLVL;
      req->runlevel = argv[0][0];
      req->sleeptime = shutdown_timeout;
    }
}
